/*
	This script must be executed on the development server (@GOLD_SERVER@). 
	
	Make sure VHAISHSQLZ4$ has full control acccess to the AG share
	A folder share - AutomatedBuildBackup must also exist

	ADDING SET RECOVERY FULL WITH NO_WAIT TO SAVE TIME - needed for AG
*/

USE master;


IF SERVERPROPERTY( 'MachineName' ) = '@GOLD_SERVER@'
	BEGIN
		ALTER DATABASE [@UT_DB_NAME@] SET RECOVERY FULL WITH NO_WAIT;

		BACKUP DATABASE [@UT_DB_NAME@]
		TO DISK = N'\\@PR_REPLICA@\AG\@UT_DB_NAME@_FOR_AG.BAK' 
		WITH NOFORMAT, INIT, SKIP, NOREWIND, NOUNLOAD, STATS = 10;

		ALTER DATABASE [@UT_DB_NAME@_MIRROR] SET RECOVERY FULL WITH NO_WAIT;

		BACKUP DATABASE [@UT_DB_NAME@_MIRROR]
		TO DISK = N'\\@PR_REPLICA@\AG\@UT_DB_NAME@_MIRROR_FOR_AG.BAK' 
		WITH NOFORMAT, INIT, SKIP, NOREWIND, NOUNLOAD, STATS = 10;
	END
ELSE
	THROW 66002, 'This script must be run only on @GOLD_SERVER@', 1;


